%% code for reconstruction invidual muscle activity  from FMRI data
%% written by g.ganesh 29rd july 2009
%% explanatioon of the use of the file and variables is provided on the
%% same website 

clear all;
% variables
%beta represents the m x t matrix of regression parameters of t iteration steps and m voxels. 
%yt  represents the n x 1 vector of regressand of n data points (scans).
%Xt is the n x m matrix of voxel activity regressor
%ys regressand for selection set
%Xs regressor for selection set
%yr regressand of test set
%Xr regressor of test set

load data_sample; % sample data with EMG activity from wrist muscle (FCR) as regressands and brain activity voxels as regressor
resolution=10; % sets the resolution of parameter search. Larger value leads to fine search but longer processing time
sigma_max= 1;%sets the range of sigma to search. Default value is 1.
last=20; %loop iteration setting. Can be set a large value like 100. However larger value will increase computation time 

beta_opt=sp_regress(yt,Xt,ys,Xs,sigma_max,resolution,last);
%-------------re contruction of test set to (be used AFTER OPTIMAL SIGMA HAS BEEN DETERMINED with the above code)----
yc= Xr*beta_opt; % reconstruction in test set
R2=1- sum((yr-yc).^2)/sum((yr-mean(yr)).^2) % coeff .of performance of test
%-------------------------------------------------------------------------      
n=length(find(beta_opt~=0)) % number of selected features/regressors

% for the muscle analysis a low pass of the reconstructed data improves
% performance greatly 
[B,A]=butter(3,3/25);
yc=filtfilt(B,A,yc);
R2_filtered=1- sum((yr-yc).^2)/sum((yr-mean(yr)).^2)