function beta_opt=sp_regress(yt,Xt,ys,Xs,sigma_max,resolution,last)
%syntax:
%beta_opt=sp_regress(yt,Xt,ys,Xs,resolution)
%beta_opt represents the m x t matrix of optimal regression parameters of t iteration steps and m voxels. 
%yt  represents the n x 1 vector of regressand of n training data points (scans).
%Xt is the n x m matrix of  training voxel activity regressor
%ys  vector of regressand of selection data points (scans).
%Xs is matrix of selection voxel activity regressor
%sigma_max sets the range of sigma to search. Default value is 1.
%last loop iteration setting. Can be set a large value like 100. However larger value will increase computation time 
%resolution sets the optimal parameter search resolution. Larger value will lead to larger run-time 


m=size(Xt,2);
n=size(yt,1);
BETA=zeros(m,resolution);

%%-----------------------------------------------------------------------
j=0;
for sigma=sigma_max/resolution:sigma_max/resolution:sigma_max
beta=zeros(m,last);
beta(:,1)=ones(m,1);
j=j+1;
%-----------------------------------------------------------------------
% thresh=.05; % threshold of 5% 
%while (abs(e(i-1)-e(i-2))>e(i-1)*thresh)
i=1;
while (i<last)
    V=diag(abs(beta(:,i)));
    beta(:,i+1)=V*inv(sigma^2*diag(ones(m,1))+V*Xt'*Xt*V)*V*Xt'*yt;
   % e(i)=sum(abs(yt-Xt*beta(:,i+1)));
     i=i+1;
end;
%---------------------------------------------------
yc= Xs*beta(:,last); % reconstruction in selection set
BETA(:,j)=beta(:,last);
R2(j)=1- sum((ys-yc).^2)/sum((ys-mean(ys)).^2); % coeff .of performance calculation
end;

save dd BETA R2;
beta_opt=BETA(:,max(find(R2==max(R2))));
