function	[W, dY] = sequential_weight_update(W,dY,X,XX,A)
% component-wise weight update to minimize error
%   [W, dY] = sequential_weight_update(W,dY,X,XX,A)
% W  : N x M : weight 
% dY : N x T : residual error , dY = Y - W * X
% X  : M x T : input
% XX : M x 1 : input variance,  XX = sum(X.^2,2) = diag(X * X')
% A  : M x 1 : weight precision parameter alpha

M = size(X,1);
N = size(dY,1);

dYX = zeros(N,1);
dW  = zeros(N,1);

for n=1:M
	% Error correlation with inputs
    dYX = dY * X(n,:)';      % N x 1

    % Weight update
    dW  = (dYX - A(n) * W(:,n))./ (XX(n) + A(n));  % ( N x 1 )
    W(:,n)  = W(:,n) + dW;
    dY = dY - dW * X(n,:);
end
