function    [dY] = error_delay_time(X,Y,W,T,N,M,D,tau);

% Y : ( T x N) x Ntrial
% X : (Tx x M) x Ntrial
% W : ( D x M) x N
% Xdelay(t) = [X(t+tau*(D-1)); ... ; X(t+tau); X(t)]
% dY = Y - X * W

[NY, Ntr] = size(Y);
[NX, Ntr] = size(X);

Tdelay = tau*(D-1);

dY = Y;

wid = 0;

% Loop for each spatial dimension
for m=1:M
	tid = 1 + Tdelay;
	% Loop for each time delay
	for j=1:D
		tend = tid + T - 1;
		wid = wid +1;
		for n = 1:Ntrial
			dY(:,:,n) = dY(:,:,n) - X(tid:tend, m, n) * W(wid,:);
		end
	end
	tid = tid - tau;
end

%	for n = 1:Ntrial
%		dY  = Y(:,:,n) ;
%	    
%	    for j=1:D
%	    	dY = dY - W(:,Wid(j,1):Wid(j,2)) * X(:,Tid(j,1):Tid(j,2),n);
%	    end
%    end
