% Generate Simulation DATA for TESTING
%   
% gen_simudata.m : from SLR ver 0.312
% slr_view_data_multi.m : from SLR ver 0.312
%
% 2009/05/29 OY  

%
% PARAMETER SETTING
%
D = 100;
Ntr = 100; 
Nte = 100;

% mean
mu1 = zeros(D,1);
mu2 = [1.0; 0; zeros(D-2,1)];
% covariance
S = diag(ones(D,1));
ro = 0.8;
S(1,2) = ro;
S(2,1) = ro;

%
% DATA GENERATION
%
[TRAIN_LABEL, TRAIN_DATA, TEST_LABEL, TEST_DATA, g] = gen_simudata([mu1 mu2], S, Ntr, Nte);

%
% PLOT DATA
%
figure,
slr_view_data(TRAIN_LABEL, TRAIN_DATA)
title('TRAINING DATA');
figure,
slr_view_data(TEST_LABEL, TEST_DATA)
title('TEST DATA');

%
% SAVE DATA
%

comment = 'from generate_simulation_data_for_test.m, 100dim, binary';
save('sim_binary100.mat', 'TRAIN_LABEL', 'TEST_LABEL', 'TRAIN_DATA', 'TEST_DATA','comment')

%comment = 'from generate_simulation_data_for_test.m, 2dim, binary';
%save('sim_binary.mat', 'TRAIN_LABEL', 'TEST_LABEL', 'TRAIN_DATA', 'TEST_DATA','comment')
